-- update submit application

set sql_safe_updates=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_RECIPIENTS');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        T1.id AS ID,
        T3.`salutationName` AS SALUTATION_NAME,
        T8.`salutationName` AS PARENT_SALUTATION_NAME,
        T2.`firstName` AS FIRST_NAME,
        T2.`middleName` AS MIDDLE_NAME,
        T2.`lastName` AS LAST_NAME,
        T7.`emailId` AS EMAIL_ID,
        T7.`mobileNumber` AS MOBILE_NO,
        T1.`code` AS APPLICATION_CODE,
        T7.`firstName` AS PARENT_FIRSTNAME,
        T7.`lastName` AS PARENT_LASTNAME,
        T7.`mobileCountryCode` AS MOBILE_CODE   
    FROM
        application T1
            LEFT OUTER JOIN
        applicant_person T2 ON T1.applicantPersonId = T2.id
            LEFT JOIN
        salutations T3 ON T3.id = T2.salutationId
            LEFT OUTER JOIN
        external_user_association T5 ON T5.applicationId = T1.id
            LEFT OUTER JOIN
        external_users T4 ON T4.id = T5.externalUserId
            LEFT OUTER JOIN
        applicant_person_relationships T6 ON T6.applicantPersonId = T2.id
            LEFT OUTER JOIN
        applicant_person T7 ON T7.id = T6.relatedApplicantPersonId
            LEFT JOIN
        salutations T8 ON T8.id = T7.salutationId
    WHERE
        T1.id IN (namedParams)
            AND T6.relationship = \'FATHER\'
            ',
    `jsonString` = '{
        "id": 1,
        "searchResultViewColumns": [
            {
                "id": 3,
                "value": "firstName",
                "resultKey": "FIRST_NAME",
                "displayCode": "",
                "displayOrder": 2
            },
            {
                "id": 4,
                "value": "middleName",
                "resultKey": "MIDDLE_NAME",
                "displayCode": "",
                "displayOrder": 3
            },
            {
                "id": 5,
                "value": "lastName",
                "resultKey": "LAST_NAME",
                "displayCode": "",
                "displayOrder": 4
            },
            {
                "id": 6,
                "value": "emailId",
                "resultKey": "EMAIL_ID",
                "displayCode": "",
                "displayOrder": 5
            },
            {
                "id": 7,
                "value": "mobileNumber",
                "resultKey": "MOBILE_NO",
                "displayCode": "",
                "displayOrder": 6
            },
            {
                "id": 8,
                "value": "code",
                "resultKey": "APPLICATION_CODE",
                "displayCode": "",
                "displayOrder": 7
            },		 
    		{
                "id": 9,
                "value": "firstName",
                "resultKey": "PARENT_FIRSTNAME",
                "displayCode": "",
                "displayOrder": 8
            },
    		{
                "id": 10,
                "value": "lastName",
                "resultKey": "PARENT_LASTNAME",
                "displayCode": "",
                "displayOrder": 9
            },
    		{
                "id": 11,
                "value": "salutationName",
                "resultKey": "PARENT_SALUTATION_NAME",
                "displayCode": "",
                "displayOrder": 10
            },
    		{
                "id": 12,
                "value": "salutationName",
                "resultKey": "SALUTATION_NAME",
                "displayCode": "",
                "displayOrder": 11
            }
        ]
    }'
WHERE
    `dataProviderId` = @dtproviderId;

    
    
SET @msgTemplateCnfgId=(SELECT id FROM msg_template_config WHERE `code`='Submit Application Template');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Application ID&nbsp;<strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Dear&nbsp;<strong>$recipientData[&quot;PARENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;PARENT_LASTNAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Thank you for your interest in applying and submitting your application for <strong>$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong>. We have received your application fee and will now proceed with your application.</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your application will now be assessed by the school and, depending on the grade (form or standard) you are applying for, there may be an additional assessment/interview. Should this be required, we will contact you&nbsp;telephonically to arrange a suitable time and date and the details will be emailed to you.&nbsp;</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">To access your &ldquo;Application Portal&rdquo;, please use the following login details to monitor your application:</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">URL: <a href="http://stasy-uat.academiaerp.com">stasy-uat.academiaerp.com</a></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Username:&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong><br />
			Password:&nbsp;<strong>$templateData[&quot;PASSWORD&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Should you have any queries please contact <strong>$templateData[&quot;ACADEMY_EMAILID&quot;]</strong>.</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Kind regards,<br />
			$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]</p>

			<p>&nbsp;</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.in/mailer/academia_email.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @msgTemplateCnfgId and msgDeliveryModeId = 1;


UPDATE `msg_template` 
SET 
    `msgContent` = 'Dear $recipientData["PARENT_FIRSTNAME"] $recipientData["PARENT_LASTNAME"],Thank you for your application and payment. We will be touch with more detail soon. $templateData["ACADEMY_NAME_LOCATION"]'
WHERE `msgTemplateConfigId`= @msgTemplateCnfgId and msgDeliveryModeId = 2;


set sql_safe_updates=1;

